/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.context;

import dev.derklaro.aerogel.Injector;
import dev.derklaro.aerogel.member.MemberInjector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MemberInjectionRequest {
    private final long flag;
    private final Class<?> targetClass;
    private final Object constructedValue;
    private final Injector parentInjector;
    private final int hashCode;

    public MemberInjectionRequest(long flag, @NotNull Class<?> targetClass, @Nullable Object constructedValue, @NotNull Injector parentInjector) {
        this.flag = flag;
        this.targetClass = targetClass;
        this.constructedValue = constructedValue;
        this.parentInjector = parentInjector;
        this.hashCode = targetClass.hashCode() ^ System.identityHashCode(constructedValue);
    }

    public void executeMemberInjection() {
        MemberInjector memberInjector = this.parentInjector.memberInjector(this.targetClass);
        memberInjector.inject(this.constructedValue, this.flag);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemberInjectionRequest that = (MemberInjectionRequest)o;
        return this.hashCode == that.hashCode;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

