/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.context;

import dev.derklaro.aerogel.ContextualProvider;
import dev.derklaro.aerogel.Element;
import dev.derklaro.aerogel.InjectionContext;
import dev.derklaro.aerogel.internal.context.DefaultInjectionContext;
import dev.derklaro.aerogel.internal.context.LazyContextualProvider;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@API(status=API.Status.INTERNAL, since="2.0", consumers={"dev.derklaro.aerogel.internal.*"})
public final class InjectionContextProvider {
    private static final ThreadLocal<DefaultInjectionContext> CURRENT_ROOT_CONTEXT = new ThreadLocal();

    private InjectionContextProvider() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static DefaultInjectionContext enterRootContext(@NotNull ContextualProvider<?> callingBinding, @NotNull Type constructingType) {
        return InjectionContextProvider.enterRootContext(callingBinding, constructingType, Collections.emptyList());
    }

    @NotNull
    static DefaultInjectionContext enterRootContext(@NotNull ContextualProvider<?> callingBinding, @NotNull Type constructingType, @NotNull List<LazyContextualProvider> overriddenDirectInstances) {
        DefaultInjectionContext currentRootContext = CURRENT_ROOT_CONTEXT.get();
        if (currentRootContext != null) {
            return currentRootContext.enterSubcontext(constructingType, (ContextualProvider)callingBinding, (Element)null);
        }
        currentRootContext = new DefaultInjectionContext(callingBinding, constructingType, overriddenDirectInstances);
        CURRENT_ROOT_CONTEXT.set(currentRootContext);
        return currentRootContext;
    }

    public static void removeRootContext() {
        CURRENT_ROOT_CONTEXT.remove();
    }

    public static void removeRootContext(@NotNull InjectionContext expectedContext) {
        InjectionContext currentContext = CURRENT_ROOT_CONTEXT.get();
        if (currentContext == expectedContext) {
            CURRENT_ROOT_CONTEXT.remove();
        }
    }

    @Nullable
    public static InjectionContext currentRootContext() {
        return CURRENT_ROOT_CONTEXT.get();
    }
}

