/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.context;

import dev.derklaro.aerogel.ContextualProvider;
import dev.derklaro.aerogel.Element;
import dev.derklaro.aerogel.ElementMatcher;
import dev.derklaro.aerogel.InjectionContext;
import dev.derklaro.aerogel.internal.context.DefaultInjectionContext;
import dev.derklaro.aerogel.internal.context.InjectionContextProvider;
import dev.derklaro.aerogel.internal.context.LazyContextualProvider;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@API(status=API.Status.INTERNAL, since="1.0", consumers={"dev.derklaro.aerogel.internal"})
public final class DefaultInjectionContextBuilder
implements InjectionContext.Builder {
    private final List<LazyContextualProvider> overriddenInstances = new LinkedList<LazyContextualProvider>();
    private final Type constructingType;
    private final ContextualProvider<?> callingProvider;

    public DefaultInjectionContextBuilder(@NotNull Type constructingType, @NotNull ContextualProvider<?> callingProvider) {
        this.constructingType = constructingType;
        this.callingProvider = callingProvider;
    }

    @Override
    public <T> @NotNull InjectionContext.Builder override(@NotNull Type type, @Nullable T instance) {
        return this.override(Element.forType(type), instance);
    }

    @Override
    public <T> @NotNull InjectionContext.Builder override(@NotNull Element element, @Nullable T instance) {
        ElementMatcher elementMatcher = ElementMatcher.matchesOne(element);
        return this.override(elementMatcher, instance);
    }

    @Override
    public <T> @NotNull InjectionContext.Builder override(@NotNull ElementMatcher elementMatcher, @Nullable T instance) {
        this.overriddenInstances.add(new LazyContextualProvider(instance, elementMatcher));
        return this;
    }

    @Override
    @NotNull
    public InjectionContext build() {
        return new DefaultInjectionContext(this.callingProvider, this.constructingType, this.overriddenInstances);
    }

    @Override
    @NotNull
    public InjectionContext enterLocal() {
        return InjectionContextProvider.enterRootContext(this.callingProvider, this.constructingType, this.overriddenInstances);
    }
}

