/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.context;

import dev.derklaro.aerogel.AerogelException;
import dev.derklaro.aerogel.ContextualProvider;
import dev.derklaro.aerogel.Element;
import dev.derklaro.aerogel.InjectionContext;
import dev.derklaro.aerogel.Injector;
import dev.derklaro.aerogel.KnownValue;
import dev.derklaro.aerogel.internal.context.ContextualProxy;
import dev.derklaro.aerogel.internal.context.InjectionContextProvider;
import dev.derklaro.aerogel.internal.context.LazyContextualProvider;
import dev.derklaro.aerogel.internal.context.MemberInjectionRequest;
import dev.derklaro.aerogel.internal.context.SelfTypeProxiedException;
import dev.derklaro.aerogel.internal.proxy.InjectionTimeProxy;
import dev.derklaro.aerogel.internal.proxy.ProxyMapping;
import dev.derklaro.aerogel.internal.reflect.TypeUtil;
import dev.derklaro.aerogel.internal.util.Preconditions;
import dev.derklaro.aerogel.member.InjectionSetting;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@API(status=API.Status.INTERNAL, since="2.0", consumers={"dev.derklaro.aerogel.internal.context"})
final class DefaultInjectionContext
implements InjectionContext {
    private static final MemberInjectionRequest[] EMPTY_MEMBER_REQUEST_ARRAY = new MemberInjectionRequest[0];
    private static final int STATE_READY = 0;
    private static final int STATE_CONSTRUCTING = 1;
    private static final int STATE_PROXIED = 2;
    private static final int STATE_DELEGATED = 3;
    private final DefaultInjectionContext root;
    private final Type constructingType;
    private final ContextualProvider<?> callingBinding;
    private final List<ContextualProxy> knownProxies;
    private final List<LazyContextualProvider> overriddenDirectInstances;
    private final Set<MemberInjectionRequest> requestedMemberInjections;
    private boolean virtual = false;
    private DefaultInjectionContext prev;
    private DefaultInjectionContext next;
    private int state = 0;
    private Object delegate;
    private ProxyMapping createdProxy;
    private Queue<DefaultInjectionContext> waitingConstructions;
    private Queue<BiConsumer<InjectionContext, Object>> constructionFinishListeners;

    public DefaultInjectionContext(@NotNull ContextualProvider<?> callingBinding, @NotNull Type constructingType, @NotNull List<LazyContextualProvider> overriddenDirectInstances) {
        this.root = this;
        this.callingBinding = callingBinding;
        this.constructingType = constructingType;
        this.knownProxies = new LinkedList<ContextualProxy>();
        this.requestedMemberInjections = new LinkedHashSet<MemberInjectionRequest>();
        this.overriddenDirectInstances = new LinkedList<LazyContextualProvider>(overriddenDirectInstances);
    }

    private DefaultInjectionContext(@NotNull DefaultInjectionContext root, @NotNull ContextualProvider<?> callingBinding, @NotNull Type constructingType) {
        this.root = root;
        this.callingBinding = callingBinding;
        this.constructingType = constructingType;
        this.knownProxies = Collections.emptyList();
        this.requestedMemberInjections = Collections.emptySet();
        this.overriddenDirectInstances = Collections.emptyList();
    }

    @Override
    @NotNull
    public Type constructingType() {
        return this.constructingType;
    }

    @Override
    @NotNull
    public ContextualProvider<?> callingProvider() {
        return this.callingBinding;
    }

    @Override
    @NotNull
    public ContextualProvider<?> resolveProvider(@NotNull Element element) {
        Injector currentInjector = this.callingBinding.injector();
        LazyContextualProvider provider = this.findOverriddenProvider(element);
        if (provider != null) {
            provider.injector = currentInjector;
            return provider;
        }
        return currentInjector.binding(element).provider(element);
    }

    @Override
    @Nullable
    public InjectionContext next() {
        return this.next;
    }

    @Override
    @Nullable
    public InjectionContext prev() {
        return this.prev;
    }

    @Override
    @NotNull
    public InjectionContext root() {
        return this.root;
    }

    @Override
    @NotNull
    public DefaultInjectionContext enterSubcontext(@NotNull Type constructingType, @NotNull ContextualProvider<?> callingBinding, @Nullable Element associatedElement) {
        LazyContextualProvider overriddenProvider;
        if (associatedElement != null && (overriddenProvider = this.findOverriddenProvider(associatedElement)) != null) {
            DefaultInjectionContext subcontext = new DefaultInjectionContext(this.root, callingBinding, constructingType);
            subcontext.state = 3;
            subcontext.delegate = overriddenProvider.get();
            return subcontext.init(this);
        }
        DefaultInjectionContext knownLeaf = this.findCreatedLeaf(callingBinding);
        if (knownLeaf != null) {
            int leafState = knownLeaf.state;
            if (leafState == 2 || leafState == 3) {
                return knownLeaf;
            }
            Class<?> ourRawType = TypeUtil.rawType(this.constructingType);
            if (ourRawType.isInterface()) {
                if (this.createdProxy == null) {
                    ContextualProxy createdProxy = this.findReusableProxy(this.callingBinding);
                    if (createdProxy != null) {
                        this.setProxy(createdProxy);
                    } else {
                        ProxyMapping proxyMapping = InjectionTimeProxy.makeProxy(ourRawType);
                        LeafWaitingConstructionRemoveTask proxyRemoveListener = new LeafWaitingConstructionRemoveTask(knownLeaf);
                        ContextualProxy proxy = new ContextualProxy(proxyRemoveListener, proxyMapping, this.callingBinding);
                        this.setProxy(proxy);
                        Queue<DefaultInjectionContext> waitingConstructions = knownLeaf.waitingConstructions;
                        if (waitingConstructions == null) {
                            knownLeaf.waitingConstructions = waitingConstructions = new LinkedList<DefaultInjectionContext>();
                        }
                        waitingConstructions.add(this);
                    }
                }
                throw SelfTypeProxiedException.INSTANCE;
            }
            Class<?> leafRawType = TypeUtil.rawType(knownLeaf.constructingType);
            if (leafRawType.isInterface()) {
                DefaultInjectionContext subcontext = new DefaultInjectionContext(this.root, callingBinding, constructingType);
                subcontext.virtual = true;
                subcontext.state = 2;
                subcontext.init(this);
                ContextualProxy createdProxy = this.findReusableProxy(callingBinding);
                if (createdProxy != null) {
                    subcontext.setProxy(createdProxy);
                } else {
                    MarkerConstructionDoneListener listener = new MarkerConstructionDoneListener(subcontext);
                    knownLeaf.addConstructionListener(listener);
                    ProxyMapping proxyMapping = InjectionTimeProxy.makeProxy(leafRawType);
                    LeafConstructionListenerRemoveTask proxyRemoveListener = new LeafConstructionListenerRemoveTask(knownLeaf, listener);
                    ContextualProxy proxy = new ContextualProxy(proxyRemoveListener, proxyMapping, callingBinding);
                    subcontext.setProxy(proxy);
                }
                return subcontext;
            }
            StringBuilder treeInfoBuilder = new StringBuilder();
            DefaultInjectionContext ctx = this.root;
            do {
                if (ctx != this.root) {
                    treeInfoBuilder.append(" >--> ");
                }
                treeInfoBuilder.append("[ ").append(TypeUtil.toPrettyString(ctx.constructingType));
                if (ctx == knownLeaf) {
                    treeInfoBuilder.append(" <-- here");
                }
                treeInfoBuilder.append(" ]");
            } while ((ctx = ctx.next) != null);
            throw AerogelException.forMessage(String.format("Detected cyclic dependency while constructing %s. See traverse tree for more info: %s", this.root.constructingType, treeInfoBuilder.append(" >--> [ ").append(TypeUtil.toPrettyString(constructingType)).append(" ]")));
        }
        DefaultInjectionContext subcontext = new DefaultInjectionContext(this.root, callingBinding, constructingType);
        return subcontext.init(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object resolveInstance() {
        int currentState = this.state;
        if (currentState == 0) {
            this.state = 1;
            try {
                Object constructedValue = this.callingBinding.get(this);
                if (constructedValue instanceof KnownValue) {
                    List<ContextualProxy> knownProxies;
                    this.state = 3;
                    KnownValue knownValue = (KnownValue)constructedValue;
                    this.delegate = constructedValue = KnownValue.unwrap(knownValue);
                    if (knownValue.firstOccurrence() && constructedValue != null) {
                        this.requestMemberInjection(constructedValue);
                    }
                    if (!(knownProxies = this.root.knownProxies).isEmpty()) {
                        for (ContextualProxy knownProxy : knownProxies) {
                            ContextualProvider<?> callingProvider = knownProxy.callingProvider;
                            if (callingProvider != this.callingBinding || knownProxy.removeListenerExecuted) continue;
                            knownProxy.setDelegate(constructedValue);
                            knownProxy.executeRemoveListener();
                        }
                    }
                } else if (constructedValue != null) {
                    this.requestMemberInjection(constructedValue);
                }
                this.callConstructDoneListeners(constructedValue);
                this.executeWaitingConstructions(constructedValue);
                Object object = constructedValue;
                return object;
            }
            catch (SelfTypeProxiedException selfProxiedException) {
                Object object = this.createdProxy.proxy();
                return object;
            }
            finally {
                if (this.state == 1) {
                    this.state = 0;
                }
            }
        }
        if (currentState == 1) {
            throw AerogelException.forMessage("Circular call to InjectionContext#resolveInstance()!");
        }
        if (currentState == 2) {
            return this.createdProxy.proxy();
        }
        if (currentState == 3) {
            return this.delegate;
        }
        throw AerogelException.forMessage("Unable to handle context state: " + currentState);
    }

    @Override
    public void addConstructionListener(@NotNull BiConsumer<InjectionContext, Object> listener) {
        Queue<BiConsumer<InjectionContext, Object>> constructionFinishListeners = this.constructionFinishListeners;
        if (constructionFinishListeners == null) {
            this.constructionFinishListeners = constructionFinishListeners = new LinkedList<BiConsumer<InjectionContext, Object>>();
        }
        constructionFinishListeners.add(listener);
    }

    @Override
    public void requestMemberInjection(@Nullable Object value) {
        this.requestMemberInjection(value, InjectionSetting.FLAG_ALL_MEMBERS);
    }

    @Override
    public void requestMemberInjection(@Nullable Object value, long flag) {
        Class<?> valueType = value != null ? value.getClass() : TypeUtil.rawType(this.constructingType);
        MemberInjectionRequest request = new MemberInjectionRequest(flag, valueType, value, this.callingBinding.injector());
        this.root.requestedMemberInjections.add(request);
    }

    @Override
    public void finishConstruction() {
        Preconditions.checkArgument(this.root == this, "finishConstruction() call to non-root context");
        InjectionContextProvider.removeRootContext(this);
        this.validateAllProxiesAreDelegated();
        Set<MemberInjectionRequest> requestedMemberInjections = this.requestedMemberInjections;
        if (!requestedMemberInjections.isEmpty()) {
            MemberInjectionRequest[] memberInjectionRequests = requestedMemberInjections.toArray(EMPTY_MEMBER_REQUEST_ARRAY);
            requestedMemberInjections.clear();
            for (MemberInjectionRequest injectionRequest : memberInjectionRequests) {
                injectionRequest.executeMemberInjection();
            }
            if (!requestedMemberInjections.isEmpty()) {
                this.finishConstruction();
            } else {
                this.validateAllProxiesAreDelegated();
            }
        }
    }

    @Override
    public boolean virtualContext() {
        return this.virtual;
    }

    @Override
    public boolean rootContext() {
        return this.prev == null;
    }

    @Override
    public boolean leafContext() {
        return this.next == null;
    }

    @NotNull
    private DefaultInjectionContext init(@NotNull DefaultInjectionContext parent) {
        this.prev = parent;
        parent.next = this;
        return this;
    }

    @Nullable
    private DefaultInjectionContext findCreatedLeaf(@NotNull ContextualProvider<?> leafProvider) {
        DefaultInjectionContext leaf = this.prev;
        if (leaf != null) {
            do {
                if (leaf.callingBinding != leafProvider) continue;
                return leaf;
            } while ((leaf = leaf.prev) != null);
        }
        return null;
    }

    @Nullable
    private ContextualProxy findReusableProxy(@NotNull ContextualProvider<?> callingProvider) {
        List<ContextualProxy> knownProxies = this.root.knownProxies;
        if (!knownProxies.isEmpty()) {
            for (ContextualProxy knownProxy : knownProxies) {
                if (knownProxy.callingProvider != callingProvider || !knownProxy.removeListenerExecuted) continue;
                return knownProxy;
            }
        }
        return null;
    }

    private void setProxy(@NotNull ContextualProxy proxy) {
        this.state = 2;
        this.createdProxy = proxy.proxyMapping;
        this.root.knownProxies.add(proxy);
    }

    private void callConstructDoneListeners(@Nullable Object constructedValue) {
        Queue<BiConsumer<InjectionContext, Object>> constructionFinishListeners = this.constructionFinishListeners;
        if (constructionFinishListeners != null) {
            BiConsumer<InjectionContext, Object> listener;
            while ((listener = constructionFinishListeners.poll()) != null) {
                listener.accept(this, constructedValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeWaitingConstructions(@Nullable Object constructedValue) {
        Queue<DefaultInjectionContext> waitingConstructions = this.waitingConstructions;
        if (waitingConstructions != null && !waitingConstructions.isEmpty()) {
            int oldState = this.state;
            Object oldDelegate = this.delegate;
            try {
                DefaultInjectionContext waitingContext;
                this.state = 3;
                this.delegate = constructedValue;
                while ((waitingContext = waitingConstructions.poll()) != null) {
                    waitingContext.state = 0;
                    Object contextCreatedValue = waitingContext.resolveInstance();
                    ProxyMapping proxy = waitingContext.createdProxy;
                    if (proxy == null || proxy.isDelegatePresent()) continue;
                    proxy.setDelegate(contextCreatedValue);
                }
            }
            finally {
                this.state = oldState;
                this.delegate = oldDelegate;
            }
        }
    }

    private void validateAllProxiesAreDelegated() {
        List<ContextualProxy> knownProxies = this.knownProxies;
        if (!knownProxies.isEmpty()) {
            int proxiesWithoutDelegate = 0;
            for (ContextualProxy proxy : knownProxies) {
                if (proxy.proxyMapping.isDelegatePresent()) continue;
                ++proxiesWithoutDelegate;
            }
            if (proxiesWithoutDelegate > 0) {
                throw AerogelException.forMessageWithoutStack("Construction finish requested but there were " + proxiesWithoutDelegate + " proxies without a delegate");
            }
        }
    }

    @Nullable
    private LazyContextualProvider findOverriddenProvider(@NotNull Element element) {
        List<LazyContextualProvider> overriddenProviders = this.root.overriddenDirectInstances;
        if (!overriddenProviders.isEmpty()) {
            for (LazyContextualProvider overriddenProvider : overriddenProviders) {
                if (!overriddenProvider.elementMatcher().test(element)) continue;
                return overriddenProvider;
            }
        }
        return null;
    }

    private final class LeafWaitingConstructionRemoveTask
    implements Runnable {
        private final DefaultInjectionContext leaf;

        public LeafWaitingConstructionRemoveTask(DefaultInjectionContext leaf) {
            this.leaf = leaf;
        }

        @Override
        public void run() {
            Queue waitingConstructions = this.leaf.waitingConstructions;
            if (waitingConstructions != null) {
                waitingConstructions.remove(DefaultInjectionContext.this);
            }
        }
    }

    private final class MarkerConstructionDoneListener
    implements BiConsumer<InjectionContext, Object> {
        private final DefaultInjectionContext markerContext;

        public MarkerConstructionDoneListener(DefaultInjectionContext markerContext) {
            this.markerContext = markerContext;
        }

        @Override
        public void accept(@NotNull InjectionContext realContext, @Nullable Object constructedValue) {
            ProxyMapping proxyMapping = this.markerContext.createdProxy;
            if (!proxyMapping.isDelegatePresent()) {
                proxyMapping.setDelegate(constructedValue);
            }
            DefaultInjectionContext markerNext = this.markerContext.next;
            DefaultInjectionContext.this.next = markerNext;
            if (markerNext != null) {
                markerNext.prev = DefaultInjectionContext.this;
            }
        }
    }

    private static final class LeafConstructionListenerRemoveTask
    implements Runnable {
        private final DefaultInjectionContext leaf;
        private final BiConsumer<InjectionContext, Object> listener;

        public LeafConstructionListenerRemoveTask(@NotNull DefaultInjectionContext leaf, @NotNull BiConsumer<InjectionContext, Object> listener) {
            this.leaf = leaf;
            this.listener = listener;
        }

        @Override
        public void run() {
            Queue constructionFinishListeners = this.leaf.constructionFinishListeners;
            if (constructionFinishListeners != null) {
                constructionFinishListeners.remove(this.listener);
            }
        }
    }
}

