/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.context;

import dev.derklaro.aerogel.ContextualProvider;
import dev.derklaro.aerogel.internal.proxy.ProxyMapping;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@API(status=API.Status.INTERNAL, since="2.0", consumers={"dev.derklaro.aerogel.internal.context"})
final class ContextualProxy {
    final ProxyMapping proxyMapping;
    final ContextualProvider<?> callingProvider;
    Runnable removeListener;
    boolean removeListenerExecuted = false;

    public ContextualProxy(@NotNull Runnable removeListener, @NotNull ProxyMapping proxyMapping, @NotNull ContextualProvider<?> callingProvider) {
        this.removeListener = removeListener;
        this.proxyMapping = proxyMapping;
        this.callingProvider = callingProvider;
    }

    public void setDelegate(@Nullable Object delegate) {
        if (!this.proxyMapping.isDelegatePresent()) {
            this.proxyMapping.setDelegate(delegate);
        }
    }

    public void executeRemoveListener() {
        Runnable removeListener = this.removeListener;
        if (removeListener != null && !this.removeListenerExecuted) {
            removeListener.run();
            this.removeListener = null;
            this.removeListenerExecuted = true;
        }
    }
}

