/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.binding.defaults;

import dev.derklaro.aerogel.AerogelException;
import dev.derklaro.aerogel.ContextualProvider;
import dev.derklaro.aerogel.ElementMatcher;
import dev.derklaro.aerogel.Injector;
import dev.derklaro.aerogel.ScopeProvider;
import dev.derklaro.aerogel.binding.BindingConstructor;
import dev.derklaro.aerogel.binding.BindingHolder;
import dev.derklaro.aerogel.internal.binding.defaults.DefaultBindingHolder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import org.apiguardian.api.API;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@API(status=API.Status.INTERNAL, since="2.0", consumers={"dev.derklaro.aerogel.internal.binding.*"})
public abstract class BaseBindingConstructor
implements BindingConstructor {
    protected final Type constructingType;
    protected final ElementMatcher elementMatcher;
    protected final Set<ScopeProvider> scopes;
    protected final Set<Class<? extends Annotation>> unresolvedScopes;

    public BaseBindingConstructor(@NotNull Type constructingType, @NotNull ElementMatcher matcher, @NotNull Set<ScopeProvider> scopes, @NotNull Set<Class<? extends Annotation>> unresolvedScopes) {
        this.elementMatcher = matcher;
        this.constructingType = constructingType;
        this.scopes = scopes;
        this.unresolvedScopes = unresolvedScopes;
    }

    @Override
    @NotNull
    public BindingHolder construct(@NotNull Injector injector) throws AerogelException {
        ContextualProvider<Object> provider = this.constructProvider(injector);
        ContextualProvider<Object> scopedProvider = this.applyScopes(injector, provider);
        return new DefaultBindingHolder(injector, this.elementMatcher, scopedProvider);
    }

    @NotNull
    protected ContextualProvider<Object> applyScopes(@NotNull Injector injector, @NotNull ContextualProvider<Object> provider) {
        for (ScopeProvider scopeProvider : this.scopes) {
            provider = scopeProvider.applyScope(this.constructingType, this.elementMatcher, provider);
        }
        for (Class clazz : this.unresolvedScopes) {
            ScopeProvider resolvedScope = injector.scope(clazz);
            if (resolvedScope == null) {
                throw AerogelException.forMessage("Unable to resolve scope for annotation @" + clazz.getName());
            }
            provider = resolvedScope.applyScope(this.constructingType, this.elementMatcher, provider);
        }
        return provider;
    }

    @ApiStatus.OverrideOnly
    @NotNull
    protected abstract ContextualProvider<Object> constructProvider(@NotNull Injector var1);
}

