/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.binding.constructors;

import dev.derklaro.aerogel.AerogelException;
import dev.derklaro.aerogel.ContextualProvider;
import dev.derklaro.aerogel.Element;
import dev.derklaro.aerogel.ElementMatcher;
import dev.derklaro.aerogel.Injector;
import dev.derklaro.aerogel.Provider;
import dev.derklaro.aerogel.ScopeProvider;
import dev.derklaro.aerogel.binding.BindingHolder;
import dev.derklaro.aerogel.internal.binding.defaults.BaseBindingConstructor;
import dev.derklaro.aerogel.internal.provider.FunctionalContextualProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiFunction;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;

@API(status=API.Status.INTERNAL, since="2.0", consumers={"dev.derklaro.aerogel.internal.binding.*"})
public final class LazyProviderBindingConstructor
extends BaseBindingConstructor {
    private final BiFunction<Element, Injector, Provider<Object>> providerFactory;

    public LazyProviderBindingConstructor(@NotNull ElementMatcher matcher, @NotNull Set<ScopeProvider> scopes, @NotNull Set<Class<? extends Annotation>> unresolvedScopes, @NotNull BiFunction<Element, Injector, Provider<Object>> providerFactory) {
        super((Type)((Object)Object.class), matcher, scopes, unresolvedScopes);
        this.providerFactory = providerFactory;
    }

    @Override
    @NotNull
    public BindingHolder construct(@NotNull Injector injector) throws AerogelException {
        return new LazyBindingHolder(injector);
    }

    @Override
    @NotNull
    protected ContextualProvider<Object> constructProvider(@NotNull Injector injector) {
        throw new UnsupportedOperationException();
    }

    @API(status=API.Status.INTERNAL, since="2.0")
    private final class LazyBindingHolder
    implements BindingHolder {
        private final Injector injector;
        private final Map<Element, ContextualProvider<Object>> providerCache;

        public LazyBindingHolder(Injector injector) {
            this.injector = injector;
            this.providerCache = new WeakHashMap<Element, ContextualProvider<Object>>();
        }

        @Override
        @NotNull
        public Injector injector() {
            return this.injector;
        }

        @Override
        @NotNull
        public ElementMatcher elementMatcher() {
            return LazyProviderBindingConstructor.this.elementMatcher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public ContextualProvider<Object> provider(@NotNull Element requestedElement) {
            LazyBindingHolder lazyBindingHolder = this;
            synchronized (lazyBindingHolder) {
                ContextualProvider<Object> baseProvider;
                ContextualProvider provider = this.providerCache.get(requestedElement);
                if (provider == null && (baseProvider = this.requestBaseProvider(requestedElement)) != (provider = LazyProviderBindingConstructor.this.applyScopes(this.injector, baseProvider))) {
                    this.providerCache.put(requestedElement, provider);
                }
                return provider;
            }
        }

        @NotNull
        private ContextualProvider<Object> requestBaseProvider(@NotNull Element element) {
            Provider baseProvider = (Provider)LazyProviderBindingConstructor.this.providerFactory.apply(element, this.injector);
            if (baseProvider instanceof ContextualProvider) {
                return (ContextualProvider)baseProvider;
            }
            return new FunctionalContextualProvider<Object>(this.injector, LazyProviderBindingConstructor.this.constructingType, LazyProviderBindingConstructor.this.elementMatcher, (context, provider) -> baseProvider.get());
        }
    }
}

