/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.binding.constructors;

import dev.derklaro.aerogel.AerogelException;
import dev.derklaro.aerogel.ContextualProvider;
import dev.derklaro.aerogel.ElementMatcher;
import dev.derklaro.aerogel.InjectionContext;
import dev.derklaro.aerogel.Injector;
import dev.derklaro.aerogel.ScopeProvider;
import dev.derklaro.aerogel.internal.PassthroughException;
import dev.derklaro.aerogel.internal.binding.defaults.BaseBindingConstructor;
import dev.derklaro.aerogel.internal.invoke.ParameterHelper;
import dev.derklaro.aerogel.internal.invoke.ParameterValueGetter;
import dev.derklaro.aerogel.internal.provider.FunctionalContextualProvider;
import dev.derklaro.aerogel.internal.reflect.TypeUtil;
import dev.derklaro.aerogel.internal.util.MethodHandleUtil;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.util.Set;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;

@API(status=API.Status.INTERNAL, since="2.0", consumers={"dev.derklaro.aerogel.internal.binding.*"})
public final class ConstructingBindingConstructor
extends BaseBindingConstructor {
    private final MethodHandle targetConstructor;
    private final ParameterValueGetter parameterValueGetter;

    public ConstructingBindingConstructor(@NotNull ElementMatcher elementMatcher, @NotNull Set<ScopeProvider> scopes, @NotNull Set<Class<? extends Annotation>> unresolvedScopes, @NotNull Constructor<?> targetConstructor) {
        super(targetConstructor.getDeclaringClass(), elementMatcher, scopes, unresolvedScopes);
        this.targetConstructor = MethodHandleUtil.toGenericMethodHandle(targetConstructor);
        this.parameterValueGetter = ParameterHelper.constructParameterSuppliers(targetConstructor.getParameters());
    }

    @Override
    @NotNull
    protected ContextualProvider<Object> constructProvider(@NotNull Injector injector) {
        return new FunctionalContextualProvider<Object>(injector, this.constructingType, this.elementMatcher, (context, provider) -> {
            try {
                Object[] paramValues = this.parameterValueGetter.resolveParamInstances((InjectionContext)context, injector);
                return MethodHandleUtil.invokeConstructor(this.targetConstructor, paramValues);
            }
            catch (AerogelException | PassthroughException passthroughException) {
                throw passthroughException;
            }
            catch (Throwable throwable) {
                String constructorDesc = TypeUtil.toPrettyString(this.constructingType) + "(" + this.targetConstructor.type() + ")";
                throw AerogelException.forMessagedException("Unable to construct requested value constructor " + constructorDesc, throwable);
            }
        });
    }
}

