/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.binding;

import dev.derklaro.aerogel.AerogelException;
import dev.derklaro.aerogel.Element;
import dev.derklaro.aerogel.ElementMatcher;
import dev.derklaro.aerogel.Injector;
import dev.derklaro.aerogel.Provider;
import dev.derklaro.aerogel.ScopeProvider;
import dev.derklaro.aerogel.binding.BindingBuilder;
import dev.derklaro.aerogel.binding.BindingConstructor;
import dev.derklaro.aerogel.internal.binding.constructors.ConstructingBindingConstructor;
import dev.derklaro.aerogel.internal.binding.constructors.FactoryMethodBindingConstructor;
import dev.derklaro.aerogel.internal.binding.constructors.LazyInstanceBindingConstructor;
import dev.derklaro.aerogel.internal.binding.constructors.LazyProviderBindingConstructor;
import dev.derklaro.aerogel.internal.binding.constructors.ProviderBindingConstructor;
import dev.derklaro.aerogel.internal.jakarta.JakartaBridge;
import dev.derklaro.aerogel.internal.reflect.InjectionClassLookup;
import dev.derklaro.aerogel.internal.reflect.TypeUtil;
import dev.derklaro.aerogel.internal.util.ElementHelper;
import dev.derklaro.aerogel.internal.util.Preconditions;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@API(status=API.Status.INTERNAL, since="2.0", consumers={"dev.derklaro.aerogel.*"})
public final class DefaultBindingBuilder
implements BindingBuilder {
    private static final ElementMatcher DENYING_MATCHER = element -> false;
    private final Set<ScopeProvider> scopes = new LinkedHashSet<ScopeProvider>();
    private final Set<Class<? extends Annotation>> unresolvedScopes = new LinkedHashSet<Class<? extends Annotation>>();
    private ElementMatcher elementMatcher = DENYING_MATCHER;

    @Override
    @NotNull
    public BindingBuilder bind(@NotNull Type type) {
        return this.bind(Element.forType(type));
    }

    @Override
    @NotNull
    public BindingBuilder bindFully(@NotNull Type type) {
        Class<?> rawType = TypeUtil.rawType(type);
        Element fullElement = ElementHelper.buildElement(type, rawType);
        for (Annotation annotation : rawType.getDeclaredAnnotations()) {
            if (!JakartaBridge.isScopeAnnotation(annotation)) continue;
            this.unresolvedScopes.add(annotation.annotationType());
        }
        return this.bind(fullElement);
    }

    @Override
    @NotNull
    public BindingBuilder bind(@NotNull Element element) {
        return this.bindMatching(ElementMatcher.matchesOne(element));
    }

    @Override
    @NotNull
    public BindingBuilder bindFully(@NotNull Element element) {
        Class<?> rawType = TypeUtil.rawType(element.componentType());
        for (Annotation annotation : rawType.getDeclaredAnnotations()) {
            if (!JakartaBridge.isScopeAnnotation(annotation)) continue;
            this.unresolvedScopes.add(annotation.annotationType());
        }
        return this.bind(element);
    }

    @Override
    @NotNull
    public BindingBuilder bindAll(Type ... types) {
        for (Type type : types) {
            this.bind(type);
        }
        return this;
    }

    @Override
    @NotNull
    public BindingBuilder bindAllFully(Type ... types) {
        for (Type type : types) {
            this.bindFully(type);
        }
        return this;
    }

    @Override
    @NotNull
    public BindingBuilder bindAll(Element ... elements) {
        for (Element element : elements) {
            this.bind(element);
        }
        return this;
    }

    @Override
    @NotNull
    public BindingBuilder bindAllFully(Element ... elements) {
        for (Element element : elements) {
            this.bindFully(element);
        }
        return this;
    }

    @Override
    @NotNull
    public BindingBuilder bindMatching(@NotNull ElementMatcher matcher) {
        this.elementMatcher = this.elementMatcher.or((Predicate)matcher);
        return this;
    }

    @Override
    @NotNull
    public BindingBuilder scoped(@NotNull ScopeProvider provider) {
        this.scopes.add(provider);
        return this;
    }

    @Override
    @NotNull
    public BindingBuilder scoped(@NotNull Class<? extends Annotation> scopeAnnotation) {
        this.unresolvedScopes.add(scopeAnnotation);
        return this;
    }

    @Override
    @NotNull
    public BindingConstructor toInstance(@Nullable Object instance) {
        if (instance == null) {
            return this.toProvider(Provider.immediate(null));
        }
        return this.toProvider(instance.getClass(), Provider.immediate(instance));
    }

    @Override
    @NotNull
    public BindingConstructor toLazyInstance(@NotNull Function<Injector, Object> instanceSupplier) {
        ElementMatcher elementMatcher = this.validateElementMatcher();
        LinkedHashSet<ScopeProvider> scopes = new LinkedHashSet<ScopeProvider>(this.scopes);
        LinkedHashSet<Class<? extends Annotation>> unresolvedScopes = new LinkedHashSet<Class<? extends Annotation>>(this.unresolvedScopes);
        return new LazyInstanceBindingConstructor(elementMatcher, scopes, unresolvedScopes, instanceSupplier);
    }

    @Override
    @NotNull
    public BindingConstructor toLazyProvider(@NotNull BiFunction<Element, Injector, Provider<Object>> providerSupplier) {
        ElementMatcher elementMatcher = this.validateElementMatcher();
        LinkedHashSet<ScopeProvider> scopes = new LinkedHashSet<ScopeProvider>(this.scopes);
        LinkedHashSet<Class<? extends Annotation>> unresolvedScopes = new LinkedHashSet<Class<? extends Annotation>>(this.unresolvedScopes);
        return new LazyProviderBindingConstructor(elementMatcher, scopes, unresolvedScopes, providerSupplier);
    }

    @Override
    @NotNull
    public BindingConstructor toProvider(@NotNull Provider<Object> provider) {
        ElementMatcher elementMatcher = this.validateElementMatcher();
        LinkedHashSet<ScopeProvider> scopes = new LinkedHashSet<ScopeProvider>(this.scopes);
        LinkedHashSet<Class<? extends Annotation>> unresolvedScopes = new LinkedHashSet<Class<? extends Annotation>>(this.unresolvedScopes);
        return new ProviderBindingConstructor(elementMatcher, scopes, unresolvedScopes, provider);
    }

    @Override
    @NotNull
    public BindingConstructor toProvider(@NotNull Class<?> type, @NotNull Provider<Object> provider) {
        this.bindFully(type);
        ElementMatcher elementMatcher = this.validateElementMatcher();
        LinkedHashSet<ScopeProvider> scopes = new LinkedHashSet<ScopeProvider>(this.scopes);
        LinkedHashSet<Class<? extends Annotation>> unresolvedScopes = new LinkedHashSet<Class<? extends Annotation>>(this.unresolvedScopes);
        return new ProviderBindingConstructor(elementMatcher, scopes, unresolvedScopes, provider);
    }

    @Override
    @NotNull
    public BindingConstructor toConstructing(@NotNull Class<?> type) {
        Constructor<?> constructor = InjectionClassLookup.findInjectableConstructor(type);
        return this.toConstructing(constructor);
    }

    @Override
    @NotNull
    public BindingConstructor toConstructing(@NotNull Constructor<?> constructor) {
        this.bindFully(constructor.getDeclaringClass());
        ElementMatcher elementMatcher = this.validateElementMatcher();
        LinkedHashSet<ScopeProvider> scopes = new LinkedHashSet<ScopeProvider>(this.scopes);
        LinkedHashSet<Class<? extends Annotation>> unresolvedScopes = new LinkedHashSet<Class<? extends Annotation>>(this.unresolvedScopes);
        return new ConstructingBindingConstructor(elementMatcher, scopes, unresolvedScopes, constructor);
    }

    @Override
    @NotNull
    public BindingConstructor toConstructing(@NotNull Class<?> clazz, Class<?> ... params) {
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(params);
            return this.toConstructing(constructor);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw AerogelException.forMessage("Unable to resolve constructor in class " + clazz + " with params " + Arrays.toString(params));
        }
    }

    @Override
    @NotNull
    public BindingConstructor toFactory(@NotNull Method factoryMethod) {
        Preconditions.checkArgument(Modifier.isStatic(factoryMethod.getModifiers()), "Factory method must be static");
        Preconditions.checkArgument(factoryMethod.getReturnType() != Void.TYPE, "Factory method cannot return void");
        Element element = ElementHelper.buildElement(factoryMethod, (Annotation[][])new Annotation[][]{factoryMethod.getDeclaredAnnotations(), factoryMethod.getReturnType().getDeclaredAnnotations()});
        this.bindFully(element);
        for (Annotation annotation : factoryMethod.getDeclaredAnnotations()) {
            if (!JakartaBridge.isScopeAnnotation(annotation)) continue;
            this.unresolvedScopes.add(annotation.annotationType());
        }
        ElementMatcher elementMatcher = this.validateElementMatcher();
        LinkedHashSet<ScopeProvider> scopes = new LinkedHashSet<ScopeProvider>(this.scopes);
        LinkedHashSet<Class<? extends Annotation>> unresolvedScopes = new LinkedHashSet<Class<? extends Annotation>>(this.unresolvedScopes);
        return new FactoryMethodBindingConstructor(elementMatcher, scopes, unresolvedScopes, factoryMethod);
    }

    @Override
    @NotNull
    public BindingConstructor toFactory(@NotNull Class<?> clazz, @NotNull String name, Class<?> ... params) {
        try {
            Method factoryMethod = clazz.getMethod(name, params);
            return this.toFactory(factoryMethod);
        }
        catch (NoSuchMethodException factoryMethod) {
            try {
                Method factoryMethod2 = clazz.getDeclaredMethod(name, params);
                return this.toFactory(factoryMethod2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw AerogelException.forMessage("Unable to resolve factory method " + name + " in class " + clazz + " with params " + Arrays.toString(params));
            }
        }
    }

    @NotNull
    private ElementMatcher validateElementMatcher() {
        Preconditions.checkArgument(this.elementMatcher != DENYING_MATCHER, "No elements to match given");
        return this.elementMatcher;
    }
}

