/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.annotation;

import dev.derklaro.aerogel.AnnotationPredicate;
import dev.derklaro.aerogel.internal.annotation.AnnotationUtil;
import dev.derklaro.aerogel.internal.util.Preconditions;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@API(status=API.Status.INTERNAL, since="2.0", consumers={"dev.derklaro.aerogel.internal.*"})
public final class DefaultAnnotationPredicate
implements AnnotationPredicate {
    private final Method[] annotationMethods;
    private final Map<String, Object> annotationValues;
    private final Class<? extends Annotation> annotationType;
    private String toStringCached;

    private DefaultAnnotationPredicate(@NotNull Method[] annotationMethods, @NotNull Map<String, Object> annotationValues, @NotNull Class<? extends Annotation> annotationType) {
        this.annotationMethods = annotationMethods;
        this.annotationValues = annotationValues;
        this.annotationType = annotationType;
    }

    @Contract(pure=true)
    @NotNull
    public static AnnotationPredicate forAnnotation(@NotNull Object instance) {
        Preconditions.checkArgument(instance instanceof Annotation, "instance is not an annotation");
        Annotation annotation = (Annotation)instance;
        Class<? extends Annotation> type = annotation.annotationType();
        Method[] declaredMethods = AnnotationUtil.resolveMethods(type);
        Map<String, Object> annotationValues = AnnotationUtil.resolveAnnotationValues(annotation);
        return new DefaultAnnotationPredicate(declaredMethods, annotationValues, type);
    }

    @Override
    public boolean test(@NotNull Object annotation) {
        if (!this.annotationType.isInstance(annotation)) {
            return false;
        }
        if (this.annotationValues.isEmpty()) {
            return true;
        }
        for (Method method : this.annotationMethods) {
            Object val = this.annotationValues.get(method.getName());
            Object valOfOther = AnnotationUtil.resolveValue(method, annotation);
            if (Arrays.deepEquals(new Object[]{val}, new Object[]{valOfOther})) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    @Override
    public @Unmodifiable @NotNull Map<String, Object> annotationValues() {
        return this.annotationValues;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultAnnotationPredicate that = (DefaultAnnotationPredicate)o;
        return this.annotationValues.equals(that.annotationValues) && this.annotationType.equals(that.annotationType);
    }

    public int hashCode() {
        return Objects.hash(this.annotationType, this.annotationValues);
    }

    public String toString() {
        String finalString;
        if (this.toStringCached != null) {
            return this.toStringCached;
        }
        String prefix = String.format("@%s", this.annotationType.getSimpleName());
        Set<Map.Entry<String, Object>> entries = this.annotationValues.entrySet();
        if (!entries.isEmpty()) {
            String finalString2;
            StringJoiner joiner = new StringJoiner(", ", "(", ")");
            for (Map.Entry<String, Object> entry : entries) {
                joiner.add(String.format("%s = %s", entry.getKey(), entry.getValue()));
            }
            this.toStringCached = finalString2 = prefix + joiner;
            return this.toStringCached;
        }
        this.toStringCached = finalString = prefix + "()";
        return this.toStringCached;
    }
}

