/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.annotation;

import dev.derklaro.aerogel.AerogelException;
import dev.derklaro.aerogel.internal.util.MapUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@API(status=API.Status.INTERNAL, since="2.0", consumers={"dev.derklaro.aerogel.internal.annotation"})
final class AnnotationUtil {
    private static final Map<Class<?>, Method[]> METHOD_CACHE = MapUtil.newConcurrentMap();
    private static final Map<Class<?>, Map<String, Object>> DEFAULT_VALUES_CACHE = MapUtil.newConcurrentMap();

    private AnnotationUtil() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static Method[] resolveMethods(@NotNull Class<?> annotationClass) {
        return METHOD_CACHE.computeIfAbsent(annotationClass, Class::getDeclaredMethods);
    }

    public static @Unmodifiable @NotNull Map<String, Object> resolveDefaults(@NotNull Class<? extends Annotation> annotationClass) {
        return DEFAULT_VALUES_CACHE.computeIfAbsent(annotationClass, AnnotationUtil::resolveDefaultsNoCache);
    }

    public static @Unmodifiable @NotNull Map<String, Object> resolveAnnotationValues(@NotNull Annotation instance) {
        Method[] declaredMethods = AnnotationUtil.resolveMethods(instance.annotationType());
        LinkedHashMap<String, Object> annotationValues = new LinkedHashMap<String, Object>(declaredMethods.length);
        for (Method method : declaredMethods) {
            Object val = AnnotationUtil.resolveValue(method, instance);
            annotationValues.put(method.getName(), val);
        }
        return Collections.unmodifiableMap(annotationValues);
    }

    @NotNull
    private static Map<String, Object> resolveDefaultsNoCache(@NotNull Class<?> annotationClass) {
        Method[] declaredMethods = AnnotationUtil.resolveMethods(annotationClass);
        if (declaredMethods.length == 0) {
            return Collections.emptyMap();
        }
        if (declaredMethods.length == 1) {
            Method method = declaredMethods[0];
            Object val = AnnotationUtil.getDefault(method);
            return val == null ? Collections.emptyMap() : Collections.singletonMap(method.getName(), val);
        }
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>(declaredMethods.length);
        for (Method method : declaredMethods) {
            Object val = AnnotationUtil.getDefault(method);
            if (val == null) continue;
            values.put(method.getName(), val);
        }
        return Collections.unmodifiableMap(values);
    }

    @Nullable
    static Object getDefault(@NotNull Method method) {
        try {
            return method.getDefaultValue();
        }
        catch (TypeNotPresentException exception) {
            return null;
        }
    }

    @NotNull
    static Object resolveValue(@NotNull Method method, @NotNull Object instance) {
        try {
            return method.invoke(instance, new Object[0]);
        }
        catch (Exception exception) {
            throw AerogelException.forMessagedException("Cannot resolve annotation values", exception);
        }
    }
}

