/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal.annotation;

import dev.derklaro.aerogel.AerogelException;
import dev.derklaro.aerogel.AnnotationPredicate;
import dev.derklaro.aerogel.internal.annotation.AnnotationUtil;
import dev.derklaro.aerogel.internal.annotation.DefaultAnnotationPredicate;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;

@API(status=API.Status.INTERNAL, since="2.0", consumers={"dev.derklaro.aerogel.*"})
public final class AnnotationFactory {
    private AnnotationFactory() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static <A extends Annotation> A generateAnnotation(@NotNull Class<A> annotationType, @NotNull Map<String, Object> overriddenValues) {
        HashMap<String, Object> overriddenCopy = new HashMap<String, Object>(overriddenValues);
        Method[] declaredMethods = AnnotationUtil.resolveMethods(annotationType);
        Map<String, Object> defaultValues = AnnotationUtil.resolveDefaults(annotationType);
        for (Method method : declaredMethods) {
            String name = method.getName();
            if (defaultValues.containsKey(name) || overriddenCopy.containsKey(name)) continue;
            throw AerogelException.forMessage("Value for method " + name + " is missing when using @" + annotationType.getCanonicalName() + " as the value is not optional");
        }
        defaultValues.forEach(overriddenCopy::putIfAbsent);
        return AnnotationFactory.doGenerateAnnotation(annotationType, overriddenCopy);
    }

    @NotNull
    private static <A extends Annotation> A doGenerateAnnotation(@NotNull Class<A> annotationType, @NotNull Map<String, Object> annotationValues) {
        Object createdProxy = Proxy.newProxyInstance(annotationType.getClassLoader(), new Class[]{annotationType}, new AnnotationInvocationHandler<A>(annotationType, annotationValues));
        return (A)((Annotation)annotationType.cast(createdProxy));
    }

    private static int hashCode(@NotNull Map<String, Object> values) {
        int result = 0;
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            int valHashCode = Arrays.deepHashCode(new Object[]{entry.getValue()});
            result += 127 * entry.getKey().hashCode() ^ valHashCode;
        }
        return result;
    }

    @NotNull
    private static String toString(@NotNull Class<?> type, @NotNull Map<String, Object> values) {
        String prefix = String.format("@%s", type.getName());
        StringJoiner valueJoiner = new StringJoiner(", ", "(", ")");
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String stringifiedValue = Arrays.deepToString(new Object[]{entry.getValue()});
            String val = stringifiedValue.substring(1, stringifiedValue.length() - 1);
            valueJoiner.add(String.format("%s=%s", entry.getKey(), val));
        }
        return prefix + valueJoiner;
    }

    private static final class AnnotationInvocationHandler<A extends Annotation>
    implements InvocationHandler {
        private final Class<A> annotationType;
        private final Map<String, Object> annotationValues;
        private AnnotationPredicate predicate;

        public AnnotationInvocationHandler(@NotNull Class<A> annotationType, @NotNull Map<String, Object> annotationValues) {
            this.annotationType = annotationType;
            this.annotationValues = annotationValues;
        }

        @Override
        @NotNull
        public Object invoke(@NotNull Object proxy, @NotNull Method method, @NotNull Object[] args) {
            String invokedMethod;
            switch (invokedMethod = method.getName()) {
                case "annotationType": {
                    return this.annotationType;
                }
                case "hashCode": {
                    return AnnotationFactory.hashCode(this.annotationValues);
                }
                case "toString": {
                    return AnnotationFactory.toString(this.annotationType, this.annotationValues);
                }
                case "equals": {
                    AnnotationPredicate tester = this.predicate;
                    if (tester == null) {
                        this.predicate = tester = DefaultAnnotationPredicate.forAnnotation(proxy);
                    }
                    return tester.test(args[0]);
                }
            }
            return this.annotationValues.get(invokedMethod);
        }
    }
}

