/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal;

import dev.derklaro.aerogel.AerogelException;
import dev.derklaro.aerogel.Element;
import dev.derklaro.aerogel.Injector;
import dev.derklaro.aerogel.ScopeProvider;
import dev.derklaro.aerogel.SpecifiedInjector;
import dev.derklaro.aerogel.binding.BindingConstructor;
import dev.derklaro.aerogel.binding.BindingHolder;
import dev.derklaro.aerogel.internal.DefaultInjector;
import dev.derklaro.aerogel.internal.context.util.ContextInstanceResolveHelper;
import dev.derklaro.aerogel.internal.member.DefaultMemberInjector;
import dev.derklaro.aerogel.internal.util.InjectorUtil;
import dev.derklaro.aerogel.internal.util.MapUtil;
import dev.derklaro.aerogel.member.MemberInjector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.UnmodifiableView;

@API(status=API.Status.EXPERIMENTAL, since="2.0")
public final class DefaultSpecifiedInjector
implements SpecifiedInjector {
    private final Injector parent;
    private final Collection<BindingHolder> specificBindings;
    private final Map<Class<?>, MemberInjector> cachedMemberInjectors;

    public DefaultSpecifiedInjector(@NotNull Injector parent) {
        this.parent = parent;
        this.specificBindings = new ConcurrentLinkedQueue<BindingHolder>();
        this.cachedMemberInjectors = MapUtil.newConcurrentMap();
        this.specificBindings.add(InjectorUtil.INJECTOR_BINDING_CONSTRUCTOR.construct(this));
    }

    @Override
    @NotNull
    public Injector parent() {
        return this.parent;
    }

    @Override
    @NotNull
    public Injector install(@NotNull BindingConstructor constructor) {
        BindingHolder bindingHolder = constructor.construct(this);
        return this.parent.install(bindingHolder);
    }

    @Override
    @NotNull
    public Injector install(@NotNull Iterable<BindingConstructor> constructors) {
        for (BindingConstructor constructor : constructors) {
            this.install(constructor);
        }
        return this;
    }

    @Override
    @NotNull
    public Injector install(@NotNull BindingHolder bindingHolder) {
        return this.parent.install(bindingHolder);
    }

    @Override
    @NotNull
    public MemberInjector memberInjector(@NotNull Class<?> memberHolderClass) {
        return this.cachedMemberInjectors.computeIfAbsent(memberHolderClass, clazz -> new DefaultMemberInjector(this, (Class<?>)clazz));
    }

    @Override
    @Nullable
    public MemberInjector fastMemberInjector(@NotNull Class<?> memberHolderClass) {
        return this.cachedMemberInjectors.get(memberHolderClass);
    }

    @Override
    @NotNull
    public BindingHolder binding(@NotNull Type target) {
        return this.binding(Element.forType(target));
    }

    @Override
    @NotNull
    public BindingHolder binding(@NotNull Element element) {
        BindingHolder known = this.findSpecifiedBinding(element);
        if (known != null) {
            return known;
        }
        return this.parent.bindingOr(element, InjectorUtil.createJITBindingFactory(this, element));
    }

    @Override
    public @UnknownNullability BindingHolder bindingOr(@NotNull Element element, @NotNull Supplier<BindingHolder> factory) {
        BindingHolder known = this.findSpecifiedBinding(element);
        return known != null ? known : this.parent.bindingOr(element, factory);
    }

    @Override
    @Nullable
    public BindingHolder bindingOrNull(@NotNull Element element) {
        BindingHolder known = this.findSpecifiedBinding(element);
        return known != null ? known : this.parent.bindingOrNull(element);
    }

    @Override
    @Nullable
    public BindingHolder fastBinding(@NotNull Element element) {
        BindingHolder known = this.findSpecifiedBinding(element);
        return known != null ? known : this.parent.fastBinding(element);
    }

    @Override
    public @UnmodifiableView @NotNull Collection<BindingHolder> bindings() {
        return Collections.unmodifiableCollection(this.specificBindings);
    }

    @Override
    public @Unmodifiable @NotNull Collection<BindingHolder> allBindings() {
        LinkedList<BindingHolder> bindings = new LinkedList<BindingHolder>(this.specificBindings);
        Injector target = this.parent;
        do {
            bindings.addAll(target.bindings());
        } while ((target = target.parent()) != null);
        return Collections.unmodifiableCollection(bindings);
    }

    @Override
    @NotNull
    public Injector registerScope(@NotNull Class<? extends Annotation> scopeAnno, @NotNull ScopeProvider provider) {
        this.parent.registerScope(scopeAnno, provider);
        return this;
    }

    @Override
    @Nullable
    public ScopeProvider scope(@NotNull Class<? extends Annotation> scopeAnnotation) {
        return this.parent.scope(scopeAnnotation);
    }

    @Override
    @Nullable
    public ScopeProvider fastScope(@NotNull Class<? extends Annotation> scopeAnnotation) {
        return this.parent.fastScope(scopeAnnotation);
    }

    @Override
    public @Unmodifiable @NotNull Collection<ScopeProvider> scopes() {
        return this.parent.scopes();
    }

    @Override
    @NotNull
    public Injector firstNonSpecifiedParent() {
        Injector parent = this.parent;
        do {
            if (parent instanceof SpecifiedInjector) continue;
            return parent;
        } while ((parent = parent.parent()) != null);
        throw AerogelException.forMessage("Specified injector has no non-specified injector parent");
    }

    @Override
    @NotNull
    public Injector newChildInjector() {
        return new DefaultInjector(this);
    }

    @Override
    @NotNull
    public SpecifiedInjector newSpecifiedInjector() {
        return new DefaultSpecifiedInjector(this);
    }

    @Override
    public <T> @UnknownNullability T instance(@NotNull Class<T> type) {
        return this.instance(Element.forType(type));
    }

    @Override
    public <T> @UnknownNullability T instance(@NotNull Type type) {
        return this.instance(Element.forType(type));
    }

    @Override
    public <T> @UnknownNullability T instance(@NotNull Element element) {
        BindingHolder binding = this.binding(element);
        return (T)ContextInstanceResolveHelper.resolveInstance(element, binding);
    }

    @Override
    @NotNull
    public SpecifiedInjector installSpecified(@NotNull BindingConstructor constructor) {
        BindingHolder constructed = constructor.construct(this);
        this.specificBindings.add(constructed);
        return this;
    }

    @Override
    @NotNull
    public SpecifiedInjector installSpecified(@NotNull Iterable<BindingConstructor> constructors) {
        constructors.forEach(this::installSpecified);
        return this;
    }

    @Override
    public boolean removeBindings(@NotNull Predicate<BindingHolder> filter) {
        return this.specificBindings.removeIf(filter);
    }

    @Override
    public boolean removeConstructedBindings() {
        return this.parent.removeBindings(binding -> binding.injector() == this);
    }

    @Nullable
    private BindingHolder findSpecifiedBinding(@NotNull Element element) {
        for (BindingHolder binding : this.specificBindings) {
            if (!binding.elementMatcher().test(element)) continue;
            return binding;
        }
        return null;
    }
}

