/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal;

import dev.derklaro.aerogel.AerogelException;
import dev.derklaro.aerogel.Element;
import dev.derklaro.aerogel.Injector;
import dev.derklaro.aerogel.ScopeProvider;
import dev.derklaro.aerogel.Singleton;
import dev.derklaro.aerogel.SpecifiedInjector;
import dev.derklaro.aerogel.binding.BindingConstructor;
import dev.derklaro.aerogel.binding.BindingHolder;
import dev.derklaro.aerogel.internal.DefaultSpecifiedInjector;
import dev.derklaro.aerogel.internal.context.util.ContextInstanceResolveHelper;
import dev.derklaro.aerogel.internal.member.DefaultMemberInjector;
import dev.derklaro.aerogel.internal.util.InjectorUtil;
import dev.derklaro.aerogel.internal.util.MapUtil;
import dev.derklaro.aerogel.member.MemberInjector;
import dev.derklaro.aerogel.util.Scopes;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.UnmodifiableView;

@API(status=API.Status.INTERNAL, since="1.0", consumers={"dev.derklaro.aerogel"})
public final class DefaultInjector
implements Injector {
    private final Injector parent;
    private final Collection<BindingHolder> bindings;
    private final Map<Class<?>, MemberInjector> cachedMemberInjectors;
    private final Map<Class<? extends Annotation>, ScopeProvider> scopes;
    private final BindingHolder injectorBinding;

    public DefaultInjector(@Nullable Injector parent) {
        this.parent = parent;
        this.bindings = new ConcurrentLinkedQueue<BindingHolder>();
        this.cachedMemberInjectors = MapUtil.newConcurrentMap();
        this.scopes = MapUtil.newConcurrentMap();
        this.injectorBinding = InjectorUtil.INJECTOR_BINDING_CONSTRUCTOR.construct(this);
        this.registerScope(Singleton.class, Scopes.SINGLETON);
        this.registerScope(jakarta.inject.Singleton.class, Scopes.SINGLETON);
    }

    @Override
    @Nullable
    public Injector parent() {
        return this.parent;
    }

    @Override
    @NotNull
    public Injector newChildInjector() {
        return new DefaultInjector(this);
    }

    @Override
    @NotNull
    public SpecifiedInjector newSpecifiedInjector() {
        return new DefaultSpecifiedInjector(this);
    }

    @Override
    public <T> T instance(@NotNull Class<T> type) {
        return this.instance(Element.forType(type));
    }

    @Override
    public <T> T instance(@NotNull Type type) {
        return this.instance(Element.forType(type));
    }

    @Override
    public <T> T instance(@NotNull Element element) {
        BindingHolder bindingHolder = this.binding(element);
        return (T)ContextInstanceResolveHelper.resolveInstance(element, bindingHolder);
    }

    @Override
    @NotNull
    public Injector install(@NotNull BindingConstructor constructor) {
        BindingHolder holder = constructor.construct(this);
        return this.install(holder);
    }

    @Override
    @NotNull
    public Injector install(@NotNull Iterable<BindingConstructor> constructors) {
        for (BindingConstructor constructor : constructors) {
            this.install(constructor);
        }
        return this;
    }

    @Override
    @NotNull
    public Injector install(@NotNull BindingHolder bindingHolder) {
        this.bindings.add(bindingHolder);
        return this;
    }

    @Override
    @NotNull
    public MemberInjector memberInjector(@NotNull Class<?> memberClazz) {
        return this.cachedMemberInjectors.computeIfAbsent(memberClazz, clazz -> new DefaultMemberInjector(this, (Class<?>)clazz));
    }

    @Override
    @Nullable
    public MemberInjector fastMemberInjector(@NotNull Class<?> memberHolderClass) {
        return this.cachedMemberInjectors.get(memberHolderClass);
    }

    @Override
    @NotNull
    public BindingHolder binding(@NotNull Type target) {
        return this.binding(Element.forType(target));
    }

    @Override
    @NotNull
    public BindingHolder binding(@NotNull Element element) {
        return this.bindingOr(element, InjectorUtil.createJITBindingFactory(this, element));
    }

    @Override
    public @UnknownNullability BindingHolder bindingOr(@NotNull Element element, @NotNull Supplier<BindingHolder> factory) {
        if (InjectorUtil.INJECTOR_ELEMENT.equals(element)) {
            return this.injectorBinding;
        }
        BindingHolder holder = this.bindingOrNull(element);
        if (holder != null) {
            return holder;
        }
        if (element.hasSpecialRequirements()) {
            throw AerogelException.forMessageWithoutStack("Element " + element + " has special properties, unable to make a runtime binding for it");
        }
        BindingHolder constructed = factory.get();
        this.bindings.add(constructed);
        return constructed;
    }

    @Override
    @Nullable
    public BindingHolder bindingOrNull(@NotNull Element element) {
        BindingHolder bindingHolder = this.fastBinding(element);
        if (bindingHolder == null && this.parent != null && !InjectorUtil.INJECTOR_ELEMENT.equals(element)) {
            Injector injector = this.parent;
            do {
                if ((bindingHolder = injector.fastBinding(element)) == null) continue;
                return bindingHolder;
            } while ((injector = injector.parent()) != null);
        }
        return bindingHolder;
    }

    @Override
    @Nullable
    public BindingHolder fastBinding(@NotNull Element element) {
        for (BindingHolder binding : this.bindings) {
            if (!binding.elementMatcher().test(element)) continue;
            return binding;
        }
        return null;
    }

    @Override
    public @UnmodifiableView @NotNull Collection<BindingHolder> bindings() {
        return Collections.unmodifiableCollection(this.bindings);
    }

    @Override
    public @UnmodifiableView @NotNull Collection<BindingHolder> allBindings() {
        LinkedList<BindingHolder> bindings = new LinkedList<BindingHolder>(this.bindings);
        if (this.parent != null) {
            Injector target = this.parent;
            do {
                bindings.addAll(target.bindings());
            } while ((target = target.parent()) != null);
        }
        return Collections.unmodifiableCollection(bindings);
    }

    @Override
    @NotNull
    public Injector registerScope(@NotNull Class<? extends Annotation> scopeAnno, @NotNull ScopeProvider provider) {
        this.scopes.put(scopeAnno, provider);
        return this;
    }

    @Override
    @Nullable
    public ScopeProvider scope(@NotNull Class<? extends Annotation> scopeAnnotation) {
        ScopeProvider scope = this.scopes.get(scopeAnnotation);
        if (scope == null && this.parent != null) {
            Injector injector = this.parent;
            while ((scope = injector.fastScope(scopeAnnotation)) == null && (injector = injector.parent()) != null) {
            }
        }
        return scope;
    }

    @Override
    @Nullable
    public ScopeProvider fastScope(@NotNull Class<? extends Annotation> scopeAnnotation) {
        return this.scopes.get(scopeAnnotation);
    }

    @Override
    public @Unmodifiable @NotNull Collection<ScopeProvider> scopes() {
        HashSet<ScopeProvider> scopes = new HashSet<ScopeProvider>(this.scopes.values());
        if (this.parent != null) {
            Injector target = this.parent;
            do {
                scopes.addAll(target.scopes());
            } while ((target = target.parent()) != null);
        }
        return Collections.unmodifiableCollection(scopes);
    }

    @Override
    public boolean removeBindings(@NotNull Predicate<BindingHolder> filter) {
        return this.bindings.removeIf(filter);
    }
}

