/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.internal;

import dev.derklaro.aerogel.AnnotationPredicate;
import dev.derklaro.aerogel.Element;
import dev.derklaro.aerogel.internal.annotation.AnnotationFactory;
import dev.derklaro.aerogel.internal.annotation.DefaultAnnotationPredicate;
import dev.derklaro.aerogel.internal.util.ToStringHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

@API(status=API.Status.INTERNAL, since="1.0", consumers={"dev.derklaro.aerogel.internal"})
public final class DefaultElement
implements Element {
    private final Type componentType;
    private final List<AnnotationPredicate> annotationPredicates;

    public DefaultElement(@NotNull Type componentType) {
        this.componentType = componentType;
        this.annotationPredicates = Collections.emptyList();
    }

    private DefaultElement(@NotNull Type componentType, @NotNull List<AnnotationPredicate> annotationPredicates) {
        this.componentType = componentType;
        this.annotationPredicates = Collections.unmodifiableList(annotationPredicates);
    }

    @Override
    @NotNull
    public Type componentType() {
        return this.componentType;
    }

    @Override
    public @UnmodifiableView @NotNull Collection<AnnotationPredicate> requiredAnnotations() {
        return this.annotationPredicates;
    }

    @Override
    @NotNull
    public Element requireAnnotation(@NotNull Annotation annotation) {
        AnnotationPredicate predicate = DefaultAnnotationPredicate.forAnnotation(annotation);
        LinkedList<AnnotationPredicate> annotationPredicates = new LinkedList<AnnotationPredicate>(this.annotationPredicates);
        annotationPredicates.add(predicate);
        return new DefaultElement(this.componentType, annotationPredicates);
    }

    @Override
    @NotNull
    public Element requireAnnotation(@NotNull Class<? extends Annotation> annotationType) {
        return this.requireAnnotation(annotationType, Collections.emptyMap());
    }

    @Override
    @NotNull
    public Element requireAnnotation(@NotNull Class<? extends Annotation> annotationType, @NotNull Map<String, Object> overriddenMethodValues) {
        Annotation proxied = AnnotationFactory.generateAnnotation(annotationType, overriddenMethodValues);
        return this.requireAnnotation(proxied);
    }

    @Override
    public boolean hasSpecialRequirements() {
        return !this.annotationPredicates.isEmpty();
    }

    @Override
    @NotNull
    public String toString() {
        return ToStringHelper.create(this).putField("componentType", this.componentType).putCollection("requiredAnnotations", this.annotationPredicates).toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.componentType, this.annotationPredicates);
    }

    @Override
    public boolean equals(@NotNull Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultElement)) {
            return false;
        }
        DefaultElement that = (DefaultElement)o;
        if (!this.componentType.equals(that.componentType)) {
            return false;
        }
        if (this.annotationPredicates.isEmpty() && that.annotationPredicates.isEmpty()) {
            return true;
        }
        if (this.annotationPredicates.size() != that.annotationPredicates.size()) {
            return false;
        }
        for (int i = 0; i < this.annotationPredicates.size(); ++i) {
            if (this.annotationPredicates.get(i).equals(that.annotationPredicates.get(i))) continue;
            return false;
        }
        return true;
    }
}

