/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.auto.internal.util;

import dev.derklaro.aerogel.AerogelException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;

@API(status=API.Status.INTERNAL, since="1.0.1", consumers={"dev.derklaro.aerogel.auto.internal"})
public final class TypeUtil {
    public static final String ARRAY_INDICATOR = "[]";

    private TypeUtil() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static List<? extends TypeMirror> typesOfAnnotationValue(@NotNull Runnable getter) {
        try {
            getter.run();
            throw AerogelException.forMessage("If this method was used as intended or was never touched this is bug");
        }
        catch (MirroredTypesException exception) {
            return exception.getTypeMirrors();
        }
    }

    @NotNull
    public static Map.Entry<TypeMirror, Integer> innermostComponentType(@NotNull ArrayType arrayType) {
        int depth = 0;
        TypeMirror result = arrayType;
        while (result.getKind() == TypeKind.ARRAY) {
            ++depth;
            result = result.getComponentType();
        }
        return new AbstractMap.SimpleImmutableEntry<TypeMirror, Integer>(result, depth);
    }

    @NotNull
    public static Name getBinaryName(@NotNull Elements elements, @NotNull Element element) {
        return elements.getBinaryName((TypeElement)element);
    }

    @NotNull
    public static String asRuntimeType(@NotNull TypeMirror typeMirror, @NotNull Types types, @NotNull Elements elements) {
        Element element = types.asElement(typeMirror);
        if (element != null) {
            return TypeUtil.getBinaryName(elements, element).toString();
        }
        try {
            PrimitiveType primitive = types.getPrimitiveType(typeMirror.getKind());
            return primitive.toString();
        }
        catch (IllegalArgumentException ex) {
            throw AerogelException.forMessageWithoutStack(String.format("TypeMirror kind %s has no corresponding element and is not primitive", new Object[]{typeMirror.getKind()}));
        }
    }
}

