/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.auto.internal.util;

import dev.derklaro.aerogel.internal.util.MapUtil;
import java.lang.reflect.Array;
import java.util.Map;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;

@API(status=API.Status.INTERNAL, since="1.0", consumers={"dev.derklaro.aerogel.auto.internal"})
public final class ClassLoadingUtil {
    private static final Map<String, Class<?>> PRIMITIVE_CLASSES = MapUtil.staticMap(8, map -> {
        map.put("int", Integer.TYPE);
        map.put("char", Character.TYPE);
        map.put("byte", Byte.TYPE);
        map.put("long", Long.TYPE);
        map.put("short", Short.TYPE);
        map.put("float", Float.TYPE);
        map.put("double", Double.TYPE);
        map.put("boolean", Boolean.TYPE);
    });

    private ClassLoadingUtil() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static Class<?> loadClass(@NotNull ClassLoader loader, @NotNull String name) throws ClassNotFoundException {
        Class<?> primitive = PRIMITIVE_CLASSES.get(name);
        if (primitive != null) {
            return primitive;
        }
        if (name.endsWith("[]")) {
            Class<?> componentType = ClassLoadingUtil.loadClass(loader, name.substring(0, name.length() - "[]".length()));
            return Array.newInstance(componentType, 0).getClass();
        }
        return Class.forName(name, false, loader);
    }
}

