/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.auto.internal.runtime;

import dev.derklaro.aerogel.AerogelException;
import dev.derklaro.aerogel.Element;
import dev.derklaro.aerogel.auto.internal.util.ClassLoadingUtil;
import dev.derklaro.aerogel.auto.runtime.AbstractAutoAnnotationReader;
import dev.derklaro.aerogel.binding.BindingBuilder;
import dev.derklaro.aerogel.binding.BindingConstructor;
import dev.derklaro.aerogel.internal.util.ElementHelper;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class ProvidesAutoAnnotationReader
extends AbstractAutoAnnotationReader {
    public ProvidesAutoAnnotationReader() {
        super("provides");
    }

    @Override
    @NotNull
    public Collection<BindingConstructor> readBindings(@NotNull ClassLoader sourceLoader, @NotNull DataInputStream source) throws IOException {
        try {
            short dataVersion = source.readShort();
            Class<?> boundClass = ClassLoadingUtil.loadClass(sourceLoader, source.readUTF());
            int elements = source.readInt();
            BindingBuilder builder = BindingBuilder.create();
            for (int i = 0; i < elements; ++i) {
                Class<?> providedClass = ClassLoadingUtil.loadClass(sourceLoader, source.readUTF());
                Element element = ElementHelper.buildElement(providedClass, providedClass);
                builder = builder.bindFully(element);
            }
            BindingConstructor constructor = builder.toConstructing(boundClass);
            return Collections.singleton(constructor);
        }
        catch (ClassNotFoundException exception) {
            throw AerogelException.forMessagedException("Unable to provide bindings constructors", exception);
        }
    }
}

