/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.auto.internal.runtime;

import dev.derklaro.aerogel.AerogelException;
import dev.derklaro.aerogel.auto.internal.util.ClassLoadingUtil;
import dev.derklaro.aerogel.auto.runtime.AbstractAutoAnnotationReader;
import dev.derklaro.aerogel.binding.BindingBuilder;
import dev.derklaro.aerogel.binding.BindingConstructor;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;

@API(status=API.Status.INTERNAL, since="2.0")
public final class FactoryAutoAnnotationReader
extends AbstractAutoAnnotationReader {
    public FactoryAutoAnnotationReader() {
        super("factory");
    }

    @Override
    @NotNull
    public Collection<BindingConstructor> readBindings(@NotNull ClassLoader sourceLoader, @NotNull DataInputStream source) throws IOException {
        short dataVersion = source.readShort();
        String methodName = source.readUTF();
        String enclosingClass = source.readUTF();
        CharSequence[] typeArguments = new String[source.readInt()];
        for (int i = 0; i < typeArguments.length; ++i) {
            typeArguments[i] = source.readUTF();
        }
        try {
            Class<?> declaringClass = ClassLoadingUtil.loadClass(sourceLoader, enclosingClass);
            Class[] params = new Class[typeArguments.length];
            for (int i = 0; i < typeArguments.length; ++i) {
                params[i] = ClassLoadingUtil.loadClass(sourceLoader, (String)typeArguments[i]);
            }
            BindingConstructor constructor = BindingBuilder.create().toFactory(declaringClass, methodName, params);
            return Collections.singleton(constructor);
        }
        catch (Exception exception) {
            throw AerogelException.forMessagedException(String.format("Unable to construct factory binding on %s.%s(%s)", enclosingClass, methodName, String.join((CharSequence)", ", typeArguments)), exception);
        }
    }
}

