/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.auto.internal.runtime;

import dev.derklaro.aerogel.AerogelException;
import dev.derklaro.aerogel.Injector;
import dev.derklaro.aerogel.auto.runtime.AutoAnnotationReader;
import dev.derklaro.aerogel.auto.runtime.AutoAnnotationRegistry;
import dev.derklaro.aerogel.binding.BindingConstructor;
import dev.derklaro.aerogel.internal.util.MapUtil;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

@API(status=API.Status.INTERNAL, since="1.0", consumers={"dev.derklaro.aerogel.auto"})
public final class DefaultAutoAnnotationRegistry
implements AutoAnnotationRegistry {
    private final Map<String, AutoAnnotationReader> entries = MapUtil.newConcurrentMap();

    public DefaultAutoAnnotationRegistry() {
        ClassLoader scl = ClassLoader.getSystemClassLoader();
        ServiceLoader<AutoAnnotationReader> systemLoader = ServiceLoader.load(AutoAnnotationReader.class, scl);
        systemLoader.forEach(this::registerReader);
        ClassLoader cl = this.getClass().getClassLoader();
        if (scl != cl) {
            ServiceLoader<AutoAnnotationReader> thisLoader = ServiceLoader.load(AutoAnnotationReader.class, cl);
            thisLoader.forEach(this::registerReader);
        }
    }

    @Override
    @NotNull
    public @UnmodifiableView Map<String, AutoAnnotationReader> entries() {
        return Collections.unmodifiableMap(this.entries);
    }

    @Override
    @NotNull
    public AutoAnnotationRegistry unregisterReader(@NotNull String name) {
        this.entries.remove(name);
        return this;
    }

    @Override
    @NotNull
    public AutoAnnotationRegistry registerReader(@NotNull AutoAnnotationReader entry) {
        this.entries.putIfAbsent(entry.name(), entry);
        return this;
    }

    @Override
    @NotNull
    public Set<BindingConstructor> makeConstructors(@NotNull ClassLoader loader, @NotNull String fileName) {
        Set<BindingConstructor> set;
        block9: {
            InputStream in = loader.getResourceAsStream(fileName);
            try {
                if (in == null) {
                    throw AerogelException.forMessage("Loader " + loader + " is unable to provide " + fileName);
                }
                set = this.makeConstructors(loader, in);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw AerogelException.forMessagedException("Unable to load file " + fileName + " from " + loader, exception);
                }
            }
            in.close();
        }
        return set;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public Set<BindingConstructor> makeConstructors(@NotNull ClassLoader loader, @NotNull InputStream stream) {
        try {
            DataInputStream in;
            block12: {
                in = new DataInputStream(stream);
                if (in.available() <= 0) {
                    Set<BindingConstructor> set = Collections.emptySet();
                    return set;
                }
                break block12;
                finally {
                    in.close();
                }
            }
            HashSet<BindingConstructor> result = new HashSet<BindingConstructor>();
            while (true) {
                if (in.available() <= 0) {
                    HashSet<BindingConstructor> hashSet = result;
                    return hashSet;
                }
                String decoder = in.readUTF();
                AutoAnnotationReader entry = this.entries.get(decoder);
                if (entry == null) {
                    throw AerogelException.forMessage("Defined reader " + decoder + " is not registered");
                }
                Collection<BindingConstructor> bindings = entry.readBindings(loader, in);
                result.addAll(bindings);
            }
        }
        catch (IOException exception) {
            throw AerogelException.forMessagedException("Unable to decode the given file stream", exception);
        }
    }

    @Override
    public void installBindings(@NotNull ClassLoader loader, @NotNull String fileName, @NotNull Injector target) {
        for (BindingConstructor constructor : this.makeConstructors(loader, fileName)) {
            target.install(constructor);
        }
    }
}

