/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.auto.internal.processing;

import dev.derklaro.aerogel.auto.Provides;
import dev.derklaro.aerogel.auto.internal.util.TypeUtil;
import dev.derklaro.aerogel.auto.processing.AbstractAutoProcessingEntry;
import dev.derklaro.aerogel.auto.processing.AnnotationEntryWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;

public final class ProvidesAutoProcessingEntry
extends AbstractAutoProcessingEntry {
    public ProvidesAutoProcessingEntry() {
        super("provides", Provides.class);
    }

    @Override
    @NotNull
    public Collection<AnnotationEntryWriter> parseElements(@NotNull Collection<? extends Element> annotatedElements, @NotNull ProcessingEnvironment processingEnvironment) {
        LinkedList<AnnotationEntryWriter> writers = new LinkedList<AnnotationEntryWriter>();
        for (Element element : annotatedElements) {
            if (element.getKind() != ElementKind.CLASS) {
                processingEnvironment.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, String.format("Element of kind %s is annotated as %s but only classes are allowed to be annotated", new Object[]{element.getKind(), Provides.class.getCanonicalName()}));
                continue;
            }
            if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                processingEnvironment.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, String.format("Binding class %s must not be abstract", element.getSimpleName()));
                continue;
            }
            List<? extends TypeMirror> value = TypeUtil.typesOfAnnotationValue(() -> element.getAnnotation(Provides.class).value());
            if (value.isEmpty()) {
                processingEnvironment.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, String.format("Providing class %s provides nothing", element.getSimpleName()));
                continue;
            }
            TypeElement typeElement = (TypeElement)element;
            String bindingName = TypeUtil.getBinaryName(processingEnvironment.getElementUtils(), typeElement).toString();
            Set<String> bindings = value.stream().map(typeMirror -> TypeUtil.asRuntimeType(typeMirror, processingEnvironment.getTypeUtils(), processingEnvironment.getElementUtils())).collect(Collectors.toSet());
            writers.add(new ProvidesAnnotationEntryWriter(bindingName, bindings));
        }
        return writers;
    }

    @API(status=API.Status.INTERNAL, since="2.0")
    private static final class ProvidesAnnotationEntryWriter
    implements AnnotationEntryWriter {
        private final String bindingName;
        private final Set<String> bindings;

        public ProvidesAnnotationEntryWriter(@NotNull String bindingName, @NotNull Set<String> bindings) {
            this.bindingName = bindingName;
            this.bindings = bindings;
        }

        @Override
        public void emitEntry(@NotNull DataOutputStream target) throws IOException {
            target.writeShort(1);
            target.writeUTF(this.bindingName);
            target.writeInt(this.bindings.size());
            for (String binding : this.bindings) {
                target.writeUTF(binding);
            }
        }
    }
}

