/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.auto.internal.processing;

import dev.derklaro.aerogel.auto.Factory;
import dev.derklaro.aerogel.auto.internal.util.TypeUtil;
import dev.derklaro.aerogel.auto.processing.AbstractAutoProcessingEntry;
import dev.derklaro.aerogel.auto.processing.AnnotationEntryWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;

@API(status=API.Status.INTERNAL, since="2.0")
public final class FactoryAutoProcessingEntry
extends AbstractAutoProcessingEntry {
    public FactoryAutoProcessingEntry() {
        super("factory", Factory.class);
    }

    @NotNull
    private static List<String> parseMethodArguments(@NotNull ProcessingEnvironment env, @NotNull ExecutableElement element) {
        if (element.getParameters().isEmpty()) {
            return Collections.emptyList();
        }
        return element.getParameters().stream().map(variableElement -> {
            TypeMirror erasedType = env.getTypeUtils().erasure(variableElement.asType());
            if (erasedType.getKind() == TypeKind.ARRAY) {
                Map.Entry<TypeMirror, Integer> arrayTypeInfo = TypeUtil.innermostComponentType((ArrayType)erasedType);
                String runtimeComponentType = TypeUtil.asRuntimeType(arrayTypeInfo.getKey(), env.getTypeUtils(), env.getElementUtils());
                String array = String.join((CharSequence)"", Collections.nCopies(arrayTypeInfo.getValue(), "[]"));
                return String.format("%s%s", runtimeComponentType, array);
            }
            return TypeUtil.asRuntimeType(erasedType, env.getTypeUtils(), env.getElementUtils());
        }).collect(Collectors.toCollection(LinkedList::new));
    }

    @Override
    @NotNull
    public Collection<AnnotationEntryWriter> parseElements(@NotNull Collection<? extends Element> annotatedElements, @NotNull ProcessingEnvironment processingEnvironment) {
        LinkedList<AnnotationEntryWriter> writers = new LinkedList<AnnotationEntryWriter>();
        for (Element element : annotatedElements) {
            if (element.getKind() != ElementKind.METHOD) {
                processingEnvironment.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, String.format("Element of kind %s is annotated as %s but only methods are allowed to be annotated", new Object[]{element.getKind(), Factory.class.getCanonicalName()}));
                continue;
            }
            if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
                processingEnvironment.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, String.format("Factory method %s must be static", element.getSimpleName()));
                continue;
            }
            ExecutableElement executableElement = (ExecutableElement)element;
            if (executableElement.getReturnType().getKind() == TypeKind.VOID) {
                processingEnvironment.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, String.format("Factory method %s returns void but an actual type is expected", element.getSimpleName()));
                continue;
            }
            String methodName = element.getSimpleName().toString();
            List<String> methodArguments = FactoryAutoProcessingEntry.parseMethodArguments(processingEnvironment, executableElement);
            String enclosingClass = TypeUtil.getBinaryName(processingEnvironment.getElementUtils(), element.getEnclosingElement()).toString();
            writers.add(new FactoryAnnotationEntryWriter(methodName, enclosingClass, methodArguments));
        }
        return writers;
    }

    @API(status=API.Status.INTERNAL, since="2.0")
    private static final class FactoryAnnotationEntryWriter
    implements AnnotationEntryWriter {
        private final String methodName;
        private final String enclosingClass;
        private final List<String> methodArguments;

        public FactoryAnnotationEntryWriter(@NotNull String methodName, @NotNull String enclosingClass, @NotNull List<String> methodArguments) {
            this.methodName = methodName;
            this.enclosingClass = enclosingClass;
            this.methodArguments = methodArguments;
        }

        @Override
        public void emitEntry(@NotNull DataOutputStream target) throws IOException {
            target.writeShort(1);
            target.writeUTF(this.methodName);
            target.writeUTF(this.enclosingClass);
            target.writeInt(this.methodArguments.size());
            for (String type : this.methodArguments) {
                target.writeUTF(type);
            }
        }
    }
}

