/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel.auto.internal.processing;

import dev.derklaro.aerogel.AerogelException;
import dev.derklaro.aerogel.auto.processing.AnnotationEntryWriter;
import dev.derklaro.aerogel.auto.processing.AutoProcessingEntry;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="1.0", consumers={"dev.derklaro.aerogel.auto.internal"})
public final class AutoInjectAnnotationProcessor
extends AbstractProcessor {
    private static final String OPTION_OUTPUT_FILE_NAME = "aerogelAutoFileName";
    private static final JavaFileManager.Location OUTPUT_FILE_LOCATION = StandardLocation.CLASS_OUTPUT;
    private final Set<AutoProcessingEntry> processingEntries = new HashSet<AutoProcessingEntry>();
    private final Map<String, Set<AnnotationEntryWriter>> foundEntries = new HashMap<String, Set<AnnotationEntryWriter>>();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        ServiceLoader<AutoProcessingEntry> processingLoader = ServiceLoader.load(AutoProcessingEntry.class, this.getClass().getClassLoader());
        processingLoader.forEach(this.processingEntries::add);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedOptions() {
        return new HashSet<String>(Collections.singleton(OPTION_OUTPUT_FILE_NAME));
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return this.processingEntries.stream().flatMap(entry -> entry.supportedAnnotations().stream()).map(Class::getCanonicalName).collect(Collectors.toSet());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            if (!this.foundEntries.isEmpty()) {
                try {
                    String fileName = this.processingEnv.getOptions().getOrDefault(OPTION_OUTPUT_FILE_NAME, "auto-config.aero");
                    FileObject file = this.processingEnv.getFiler().createResource(OUTPUT_FILE_LOCATION, "", fileName, new Element[0]);
                    try (DataOutputStream out = new DataOutputStream(file.openOutputStream());){
                        for (Map.Entry<String, Set<AnnotationEntryWriter>> entry : this.foundEntries.entrySet()) {
                            for (AnnotationEntryWriter writer : entry.getValue()) {
                                out.writeUTF(entry.getKey());
                                writer.emitEntry(out);
                            }
                        }
                    }
                }
                catch (IOException exception) {
                    throw AerogelException.forMessagedException("Exception writing data to output file", exception);
                }
            }
            return false;
        }
        for (AutoProcessingEntry processingEntry : this.processingEntries) {
            Collection elements;
            Collection<AnnotationEntryWriter> writers = processingEntry.parseElements(elements = (Collection)processingEntry.supportedAnnotations().stream().flatMap(annotation -> roundEnv.getElementsAnnotatedWith((Class<? extends Annotation>)annotation).stream()).collect(Collectors.toSet()), this.processingEnv);
            if (writers.isEmpty()) continue;
            this.foundEntries.computeIfAbsent(processingEntry.name(), $2 -> new LinkedHashSet()).addAll(writers);
        }
        return false;
    }
}

