/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel;

import dev.derklaro.aerogel.AerogelException;
import dev.derklaro.aerogel.internal.provider.ImmediateProvider;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

@FunctionalInterface
@API(status=API.Status.STABLE, since="1.0")
public interface Provider<T>
extends Supplier<T> {
    @NotNull
    public static <C> Provider<C> immediate(@Nullable C provided) {
        return new ImmediateProvider<C>(provided);
    }

    @Override
    @Nullable
    public T get() throws AerogelException;

    @Nullable
    default public T getOrNull() {
        return this.getOrElse(null);
    }

    default public @UnknownNullability T getOrElse(@Nullable T defaultValue) {
        try {
            return this.get();
        }
        catch (AerogelException exception) {
            return defaultValue;
        }
    }

    @NotNull
    default public Optional<T> getAsOptional() {
        return Optional.ofNullable(this.getOrNull());
    }

    @NotNull
    default public Provider<T> orElse(@Nullable T defaultValue) {
        return () -> this.getOrElse(defaultValue);
    }

    @NotNull
    default public Provider<T> orElse(@NotNull Provider<? extends T> fallback) {
        return () -> {
            T currentValue = this.getOrNull();
            return currentValue == null ? fallback.getOrNull() : currentValue;
        };
    }

    @NotNull
    default public Provider<T> orElseGet(@NotNull Supplier<? extends T> supplier) {
        return () -> {
            T currentValue = this.getOrNull();
            return currentValue == null ? supplier.get() : currentValue;
        };
    }

    @NotNull
    default public <R> Provider<R> map(@NotNull Function<? super T, ? extends R> mapper) {
        return () -> {
            T currentValue = this.getOrNull();
            return currentValue == null ? null : mapper.apply((T)currentValue);
        };
    }

    @NotNull
    default public <R> Provider<R> flatMap(@NotNull Function<? super T, ? extends Provider<? extends R>> mapper) {
        return () -> {
            T currentValue = this.getOrNull();
            if (currentValue == null) {
                return null;
            }
            Provider provider = (Provider)mapper.apply((T)currentValue);
            return provider == null ? null : provider.getOrNull();
        };
    }

    @NotNull
    default public <R, S> Provider<S> combine(@NotNull Provider<R> second, @NotNull BiFunction<T, R, S> combiner) {
        return () -> {
            T currentValue = this.getOrNull();
            if (currentValue == null) {
                return null;
            }
            T secondValue = second.getOrNull();
            return secondValue == null ? null : combiner.apply(currentValue, secondValue);
        };
    }
}

