/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel;

import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@API(status=API.Status.STABLE, since="2.0")
public final class KnownValue {
    private final Object inner;
    private final boolean firstOccurrence;

    private KnownValue(@Nullable Object inner, boolean firstOccurrence) {
        this.inner = inner;
        this.firstOccurrence = firstOccurrence;
    }

    @NotNull
    public static KnownValue of(@Nullable Object inner) {
        return new KnownValue(inner, true);
    }

    public static Object unwrap(@NotNull KnownValue value) {
        Object inner = value.inner();
        if (inner instanceof KnownValue) {
            while (inner instanceof KnownValue) {
                KnownValue innerValue = (KnownValue)inner;
                inner = innerValue.inner();
            }
        }
        return inner;
    }

    @Nullable
    public Object inner() {
        return this.inner;
    }

    public boolean firstOccurrence() {
        return this.firstOccurrence;
    }

    @Contract(pure=true)
    @NotNull
    public KnownValue asSecondOccurrence() {
        return new KnownValue(this.inner, false);
    }
}

