/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel;

import dev.derklaro.aerogel.ContextualProvider;
import dev.derklaro.aerogel.Element;
import dev.derklaro.aerogel.ElementMatcher;
import dev.derklaro.aerogel.internal.context.DefaultInjectionContextBuilder;
import dev.derklaro.aerogel.internal.context.InjectionContextProvider;
import java.lang.reflect.Type;
import java.util.function.BiConsumer;
import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@API(status=API.Status.STABLE, since="1.0")
public interface InjectionContext {
    @Nullable
    public static InjectionContext currentRootContext() {
        return InjectionContextProvider.currentRootContext();
    }

    @Contract(pure=true)
    @NotNull
    public static Builder builder(@NotNull Type constructingType, @NotNull ContextualProvider<?> callingProvider) {
        return new DefaultInjectionContextBuilder(constructingType, callingProvider);
    }

    @NotNull
    public Type constructingType();

    @NotNull
    public ContextualProvider<?> callingProvider();

    @NotNull
    public ContextualProvider<?> resolveProvider(@NotNull Element var1);

    @Nullable
    public InjectionContext next();

    @Nullable
    public InjectionContext prev();

    @NotNull
    public InjectionContext root();

    @NotNull
    public InjectionContext enterSubcontext(@NotNull Type var1, @NotNull ContextualProvider<?> var2, @Nullable Element var3);

    @Nullable
    public Object resolveInstance();

    public void addConstructionListener(@NotNull BiConsumer<InjectionContext, Object> var1);

    public void requestMemberInjection(@Nullable Object var1);

    public void requestMemberInjection(@Nullable Object var1, long var2);

    public void finishConstruction();

    public boolean virtualContext();

    public boolean rootContext();

    public boolean leafContext();

    public static interface Builder {
        @NotNull
        public <T> Builder override(@NotNull Type var1, @Nullable T var2);

        @NotNull
        public <T> Builder override(@NotNull Element var1, @Nullable T var2);

        @NotNull
        public <T> Builder override(@NotNull ElementMatcher var1, @Nullable T var2);

        @Contract(pure=true)
        @NotNull
        public InjectionContext build();

        @Contract(pure=true)
        @NotNull
        public InjectionContext enterLocal();
    }
}

