/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel;

import dev.derklaro.aerogel.Element;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
@API(status=API.Status.STABLE, since="2.0")
public interface ElementMatcher
extends Predicate<Element> {
    @NotNull
    public static ElementMatcher matchesOne(@NotNull Element requiredElement) {
        return element -> element.equals(requiredElement);
    }

    @NotNull
    public static ElementMatcher matchesAll(@NotNull Element[] requiredElements) {
        return element -> {
            for (Element requiredElement : requiredElements) {
                if (element.equals(requiredElement)) continue;
                return false;
            }
            return true;
        };
    }

    @NotNull
    public static ElementMatcher matchesSome(@NotNull Element[] requiredElements) {
        return element -> {
            for (Element requiredElement : requiredElements) {
                if (!element.equals(requiredElement)) continue;
                return true;
            }
            return false;
        };
    }

    @Override
    public boolean test(Element var1);

    @NotNull
    default public ElementMatcher negate() {
        return element -> !this.test(element);
    }

    @NotNull
    default public ElementMatcher and(@NotNull Predicate<? super Element> other) {
        return element -> this.test(element) && other.test(element);
    }

    @NotNull
    default public ElementMatcher or(@NotNull Predicate<? super Element> other) {
        return element -> this.test(element) || other.test(element);
    }
}

