/*
 * Decompiled with CFR 0.152.
 */
package dev.derklaro.aerogel;

import dev.derklaro.aerogel.AnnotationPredicate;
import dev.derklaro.aerogel.internal.DefaultElement;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

@API(status=API.Status.STABLE, since="2.0")
public interface Element {
    @Contract(pure=true)
    @NotNull
    public static Element forType(@NotNull Type type) {
        return new DefaultElement(type);
    }

    @NotNull
    public Type componentType();

    public @UnmodifiableView @NotNull Collection<AnnotationPredicate> requiredAnnotations();

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Element requireAnnotation(@NotNull Annotation var1);

    @API(status=API.Status.STABLE, since="2.0")
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Element requireAnnotation(@NotNull Class<? extends Annotation> var1);

    @API(status=API.Status.STABLE, since="2.0")
    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public Element requireAnnotation(@NotNull Class<? extends Annotation> var1, @NotNull Map<String, Object> var2);

    @API(status=API.Status.STABLE, since="2.0")
    public boolean hasSpecialRequirements();

    @NotNull
    public String toString();

    public int hashCode();

    public boolean equals(@NotNull Object var1);
}

